# Copyright 2014, Hewlett-Packard Company
#
# Sub routine to load table OO_EXECUTION_SUMMARY
#
# Arguments:
#
# CSV File Name
# Reference to a map between DB column names and CSV column names
# Reference to DB Connection
#



sub OO_EXECUTION_SUMMARY {
	# the name of the caller table (base table of the load)
    my $loadTable = shift;

    DEBUG("[$loadTable]:Calling OO_EXECUTION_SUMMARY subroutine");
    
	# mapping from DB columns names to CSV
    my $db_csv_map_ref = shift;
	
	# DB connection
    my $db = shift;

	#base temporary table which has data from stage table
	my $baseTempTableName = shift;

	#table name
	my $tableName = shift;

	#Master table of
	my $masterTableOf = shift;
	
	#used for bridge table
	my $associationColMap = shift;
	
	# DB Column Names in the format tablename_columnname
	my @dbColumns = ("OO_EXECUTION_SUMMARY_0_ID","OO_EXECUTION_SUMMARY_0_EXECUTION_ID","OO_EXECUTION_SUMMARY_0_FLOW_UUID","OO_EXECUTION_SUMMARY_0_FLOW_PATH","OO_EXECUTION_SUMMARY_0_RESULT_STATUS_TYPE","OO_EXECUTION_SUMMARY_0_RESULT_STATUS_NAME","OO_EXECUTION_SUMMARY_0_PAUSE_REASON","OO_EXECUTION_SUMMARY_0_OWNER","OO_EXECUTION_SUMMARY_0_TRIGGERED_BY","OO_EXECUTION_SUMMARY_0_EXECUTION_NAME","OO_EXECUTION_SUMMARY_0_DURATION","OO_EXECUTION_SUMMARY_0_TRIGGER_SOURCE","OO_EXECUTION_SUMMARY_0_LOG_LEVEL","OO_EXECUTION_SUMMARY_0_RUNNING_CONF_VERSION","OO_EXECUTION_SUMMARY_0_TIMEOUT","OO_EXECUTION_SUMMARY_0_CANCEL_REASON","OO_EXECUTION_SUMMARY_0_START_TIME_LONG","OO_EXECUTION_SUMMARY_0_END_TIME_LONG","OO_EXECUTION_SUMMARY_0_STATUS","OO_EXECUTION_SUMMARY_0_isdeleted","OO_EXECUTION_SUMMARY_0_source","OO_EXECUTION_SUMMARY_0_sourceid","OO_EXECUTION_SUMMARY_0_extraction_time");
	
	my %map = %$db_csv_map_ref;    
	
    # list of business keys for this dim
    my @biz_cols = ("ID");
    # DB column names
    my @db_hdr = ("ID","EXECUTION_ID","FLOW_UUID","FLOW_PATH","RESULT_STATUS_TYPE","RESULT_STATUS_NAME","PAUSE_REASON","OWNER","TRIGGERED_BY","EXECUTION_NAME","DURATION","TRIGGER_SOURCE","LOG_LEVEL","RUNNING_CONF_VERSION","TIMEOUT","CANCEL_REASON","START_TIME_LONG","END_TIME_LONG","STATUS","isdeleted","source","sourceid","extraction_time");

    # this table name
    my $table = 'OO_EXECUTION_SUMMARY';
	
	my $temp_table = "LOCAL_TEMP_OO_EXECUTION_SUMMARY";
	my $dim_seq = "OO_EXECUTION_SUMMARY_sequence";
	my $extTempTable = "EXTERNAL_OO_EXECUTION_SUMMARY";
	my $create_temp_table_sql;

	#prepare the select column list from the column map from main and columns in this pm		
	my @colFrmMapTemp = keys %map; #first get keys from col reference map
	my $strTemp = join(",",@colFrmMapTemp);
	$strTemp =~ s/\./_0_/g; #now remove the "." with "_0_"
	#$strTemp =~ s/,/,\n/g; # replace comma with comma and new line
	my @colFrmMap = split(",",$strTemp);
	
	my %dbColumns=map{$_ =>1} @dbColumns;
	my %colFrmMap1=map{$_=>1} @colFrmMap;
	my @reqColumnsArr = grep( $colFrmMap1{$_}, @dbColumns ); #now get the intersection of two arrays
	
	my $reqSelCols = join(",",@reqColumnsArr);
	$reqSelCols =~ s/,/,\n/g;
	
	#get the columns required for group by. This will be the list of business key columns of this table and associated tables
	
	my @tmpBkColsArr = ("OO_EXECUTION_SUMMARY_0_ID");	
	
	my %tmpBkColsArr=map{$_ =>1} @tmpBkColsArr;
	my %colFrmMap2=map{$_=>1} @colFrmMap;
	my @reqGrpColumnsArr = grep( $colFrmMap2{$_}, @tmpBkColsArr ); #now get the intersection of two arrays
	
	my $reqGrpByCols = join(",",@reqGrpColumnsArr);
	$reqGrpByCols =~ s/,/,\n/g;
	
	# Create intermediate local ext temp table
	
	my $create_ddl = "CREATE LOCAL TEMPORARY TABLE  EXTERNAL_OO_EXECUTION_SUMMARY (
OO_EXECUTION_SUMMARY_0_ID float,
OO_EXECUTION_SUMMARY_0_EXECUTION_ID VARCHAR (255),
OO_EXECUTION_SUMMARY_0_FLOW_UUID VARCHAR (255),
OO_EXECUTION_SUMMARY_0_FLOW_PATH VARCHAR (1024),
OO_EXECUTION_SUMMARY_0_RESULT_STATUS_TYPE VARCHAR (255),
OO_EXECUTION_SUMMARY_0_RESULT_STATUS_NAME VARCHAR (255),
OO_EXECUTION_SUMMARY_0_PAUSE_REASON VARCHAR (255),
OO_EXECUTION_SUMMARY_0_OWNER VARCHAR (255),
OO_EXECUTION_SUMMARY_0_TRIGGERED_BY VARCHAR (255),
OO_EXECUTION_SUMMARY_0_EXECUTION_NAME VARCHAR (255),
OO_EXECUTION_SUMMARY_0_DURATION float,
OO_EXECUTION_SUMMARY_0_TRIGGER_SOURCE VARCHAR (255),
OO_EXECUTION_SUMMARY_0_LOG_LEVEL VARCHAR (255),
OO_EXECUTION_SUMMARY_0_RUNNING_CONF_VERSION float,
OO_EXECUTION_SUMMARY_0_TIMEOUT integer,
OO_EXECUTION_SUMMARY_0_CANCEL_REASON VARCHAR (255),
OO_EXECUTION_SUMMARY_0_START_TIME_LONG timestamp,
OO_EXECUTION_SUMMARY_0_END_TIME_LONG timestamp,
OO_EXECUTION_SUMMARY_0_STATUS VARCHAR (510),
OO_EXECUTION_SUMMARY_0_isdeleted integer,
OO_EXECUTION_SUMMARY_0_source VARCHAR (255),
OO_EXECUTION_SUMMARY_0_sourceid VARCHAR (255),
OO_EXECUTION_SUMMARY_0_extraction_time timestamp) ON COMMIT PRESERVE ROWS ORDER BY OO_EXECUTION_SUMMARY_0_ID ";
	DEBUG("[$loadTable]:Create ext temp table");
	my $handle = $db->prepare($create_ddl) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	# Create intermediate local temp table
	my $createLocalTempDDLSQL = "CREATE LOCAL TEMPORARY TABLE  LOCAL_TEMP_OO_EXECUTION_SUMMARY (
dsi_key_id integer,
ID float,
EXECUTION_ID VARCHAR (255),
FLOW_UUID VARCHAR (255),
FLOW_PATH VARCHAR (1024),
RESULT_STATUS_TYPE VARCHAR (255),
RESULT_STATUS_NAME VARCHAR (255),
PAUSE_REASON VARCHAR (255),
OWNER VARCHAR (255),
TRIGGERED_BY VARCHAR (255),
EXECUTION_NAME VARCHAR (255),
DURATION float,
TRIGGER_SOURCE VARCHAR (255),
LOG_LEVEL VARCHAR (255),
RUNNING_CONF_VERSION float,
TIMEOUT integer,
CANCEL_REASON VARCHAR (255),
START_TIME_LONG timestamp,
END_TIME_LONG timestamp,
STATUS VARCHAR (510),
isdeleted integer,
source VARCHAR (255),
sourceid VARCHAR (255),
extraction_time timestamp) ON COMMIT PRESERVE ROWS ORDER BY dsi_key_id ";
	DEBUG("[$loadTable]:Create local temp table");
	my $handle = $db->prepare($createLocalTempDDLSQL) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);

	# select into intermediate local temp table
	my $reqBaseSelCols = $reqSelCols;
	if( $masterTableOf ne '' ){
		my $tmpTableName = $tableName . "_0_";
		my $tmpMasterTableOf = $masterTableOf . "_0_";
		$reqBaseSelCols =~ s/$tmpTableName/$tmpMasterTableOf/g; #incase of conformedTo table conformed table name should be used
		$reqGrpByCols =~ s/$tmpTableName/$tmpMasterTableOf/g; #incase of conformedTo table conformed table name should be used
	}
	
	#for bridge table support
	if( $associationColMap ne '' ){
		my %asscnColArr = split /[,]/, $associationColMap;
		
		foreach my $dstCol (keys %asscnColArr) {				
			my $tgtColName = $masterTableOf . "_0_" . $dstCol;
			my $srcColName = $masterTableOf . "_0_" . $asscnColArr{$dstCol};
			
			$reqBaseSelCols =~ s/$srcColName/$tgtColName/g; #incase of bridge table replace association column name with actual dependent table column name
			$reqGrpByCols =~ s/$srcColName/$tgtColName/g; #incase of bridge table replace association column name with actual dependent table column name
		}			
	}
	
	# move data from ext temp table to base temp table. Duplicate deletion happens here
	my $checkDuplicate = 1;	
	if( $checkDuplicate == 1 ){
		$create_temp_table_sql = "INSERT INTO $extTempTable ( $reqSelCols ) SELECT $reqBaseSelCols FROM $baseTempTableName WHERE IDENCOL IN( SELECT MAX(IDENCOL) FROM $baseTempTableName GROUP BY $reqGrpByCols ) ";
	}
	else{
		$create_temp_table_sql = "INSERT INTO $extTempTable ( $reqSelCols ) SELECT $reqBaseSelCols FROM $baseTempTableName ";		
	}
	DEBUG("[$loadTable]:Creating/selecting to external table SQL: $create_temp_table_sql");
	$handle = $db->prepare($create_temp_table_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);

	#lock the table to avoid parallel loads
	my $lockTable = "LOCK TABLE OO_EXECUTION_SUMMARY";
	DEBUG("[$loadTable]:Locking table $tableName");
	$handle = $db->prepare($lockTable) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	#get default business key values from dimension tables
	my $OO_EXECUTION_SUMMARY_0_ID;
	my $OO_EXECUTION_SUMMARYStmt = $db->prepare("SELECT ID FROM OO_EXECUTION_SUMMARY WHERE dsi_key_id = 1 ") or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	my $OO_EXECUTION_SUMMARYRs = $OO_EXECUTION_SUMMARYStmt->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	if( $OO_EXECUTION_SUMMARYRs >= 0){
		if( my @OO_EXECUTION_SUMMARYRow = $OO_EXECUTION_SUMMARYStmt->fetchrow_array() ){
			$OO_EXECUTION_SUMMARY_0_ID = $OO_EXECUTION_SUMMARYRow[0];
			}
	}
	
	
	# Create a LOCAL TEMP table and populate it with contents of the base temp table outer joined with the contents of the DWH Dim table
	my $select_into_temp_sql = "INSERT INTO LOCAL_TEMP_OO_EXECUTION_SUMMARY
(dsi_key_id,ID,EXECUTION_ID,FLOW_UUID,FLOW_PATH,RESULT_STATUS_TYPE,RESULT_STATUS_NAME,PAUSE_REASON,OWNER,TRIGGERED_BY,EXECUTION_NAME,DURATION,TRIGGER_SOURCE,LOG_LEVEL,RUNNING_CONF_VERSION,TIMEOUT,CANCEL_REASON,START_TIME_LONG,END_TIME_LONG,STATUS,isdeleted,source,sourceid,extraction_time) 
SELECT 
(CASE WHEN OO_EXECUTION_SUMMARY.dsi_key_id IS NULL THEN OO_EXECUTION_SUMMARY_sequence.NEXTVAL ELSE OO_EXECUTION_SUMMARY.dsi_key_id END) AS dsi_key_id,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_ID,OO_EXECUTION_SUMMARY.ID) AS ID,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_EXECUTION_ID,OO_EXECUTION_SUMMARY.EXECUTION_ID) AS EXECUTION_ID,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_FLOW_UUID,OO_EXECUTION_SUMMARY.FLOW_UUID) AS FLOW_UUID,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_FLOW_PATH,OO_EXECUTION_SUMMARY.FLOW_PATH) AS FLOW_PATH,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_RESULT_STATUS_TYPE,OO_EXECUTION_SUMMARY.RESULT_STATUS_TYPE) AS RESULT_STATUS_TYPE,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_RESULT_STATUS_NAME,OO_EXECUTION_SUMMARY.RESULT_STATUS_NAME) AS RESULT_STATUS_NAME,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_PAUSE_REASON,OO_EXECUTION_SUMMARY.PAUSE_REASON) AS PAUSE_REASON,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_OWNER,OO_EXECUTION_SUMMARY.OWNER) AS OWNER,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_TRIGGERED_BY,OO_EXECUTION_SUMMARY.TRIGGERED_BY) AS TRIGGERED_BY,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_EXECUTION_NAME,OO_EXECUTION_SUMMARY.EXECUTION_NAME) AS EXECUTION_NAME,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_DURATION,OO_EXECUTION_SUMMARY.DURATION) AS DURATION,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_TRIGGER_SOURCE,OO_EXECUTION_SUMMARY.TRIGGER_SOURCE) AS TRIGGER_SOURCE,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_LOG_LEVEL,OO_EXECUTION_SUMMARY.LOG_LEVEL) AS LOG_LEVEL,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_RUNNING_CONF_VERSION,OO_EXECUTION_SUMMARY.RUNNING_CONF_VERSION) AS RUNNING_CONF_VERSION,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_TIMEOUT,OO_EXECUTION_SUMMARY.TIMEOUT) AS TIMEOUT,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_CANCEL_REASON,OO_EXECUTION_SUMMARY.CANCEL_REASON) AS CANCEL_REASON,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_START_TIME_LONG,OO_EXECUTION_SUMMARY.START_TIME_LONG) AS START_TIME_LONG,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_END_TIME_LONG,OO_EXECUTION_SUMMARY.END_TIME_LONG) AS END_TIME_LONG,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_STATUS,OO_EXECUTION_SUMMARY.STATUS) AS STATUS,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_isdeleted,OO_EXECUTION_SUMMARY.isdeleted) AS isdeleted,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_source,OO_EXECUTION_SUMMARY.source) AS source,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_sourceid,OO_EXECUTION_SUMMARY.sourceid) AS sourceid,
NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_extraction_time,OO_EXECUTION_SUMMARY.extraction_time) AS extraction_time
FROM EXTERNAL_OO_EXECUTION_SUMMARY 
LEFT OUTER JOIN (SELECT OO_EXECUTION_SUMMARY.dsi_key_id , OO_EXECUTION_SUMMARY.ID , OO_EXECUTION_SUMMARY.EXECUTION_ID , OO_EXECUTION_SUMMARY.FLOW_UUID , OO_EXECUTION_SUMMARY.FLOW_PATH , OO_EXECUTION_SUMMARY.RESULT_STATUS_TYPE , OO_EXECUTION_SUMMARY.RESULT_STATUS_NAME , OO_EXECUTION_SUMMARY.PAUSE_REASON , OO_EXECUTION_SUMMARY.OWNER , OO_EXECUTION_SUMMARY.TRIGGERED_BY , OO_EXECUTION_SUMMARY.EXECUTION_NAME , OO_EXECUTION_SUMMARY.DURATION , OO_EXECUTION_SUMMARY.TRIGGER_SOURCE , OO_EXECUTION_SUMMARY.LOG_LEVEL , OO_EXECUTION_SUMMARY.RUNNING_CONF_VERSION , OO_EXECUTION_SUMMARY.TIMEOUT , OO_EXECUTION_SUMMARY.CANCEL_REASON , OO_EXECUTION_SUMMARY.START_TIME_LONG , OO_EXECUTION_SUMMARY.END_TIME_LONG , OO_EXECUTION_SUMMARY.STATUS , OO_EXECUTION_SUMMARY.isdeleted , OO_EXECUTION_SUMMARY.source , OO_EXECUTION_SUMMARY.sourceid , OO_EXECUTION_SUMMARY.extraction_time FROM  OO_EXECUTION_SUMMARY OO_EXECUTION_SUMMARY  ) OO_EXECUTION_SUMMARY ON ( OO_EXECUTION_SUMMARY.ID = NVL(EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_ID, $OO_EXECUTION_SUMMARY_0_ID ) )
 WHERE EXTERNAL_OO_EXECUTION_SUMMARY.OO_EXECUTION_SUMMARY_0_ID is not null ";
	DEBUG("[$loadTable]:Creating LOCAL TEMP Table $temp_table");
	$handle = $db->prepare($select_into_temp_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);	
	
	# Create another LOCAL TEMP table in case of SCD6 bridge table
	my $prepare_temp_table = '';	
	if( $prepare_temp_table ne '' ){
		# scd6 bridge record consolidation
		DEBUG("[$loadTable]:Running SCD6 bridge table record consolidation SQL");
		$handle = $db->prepare($prepare_temp_table) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	}
	
	# SQL to delete duplicate records from SCD6 bridge table
	my $scd6_bridge_duplicate_removal = '';	
	if( $scd6_bridge_duplicate_removal ne '' ){
		# scd6 bridge duplicate deletion
		DEBUG("[$loadTable]:Running SCD6 bridge duplicate or incomplete record deletion");
		$handle = $db->prepare($scd6_bridge_duplicate_removal) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	}
	
	# update the LOCAL TEMP table with end_date for those records which are complete
	my $prepareEndDateUpdate = '';	
	if( $prepareEndDateUpdate ne '' ){
		# scd6 bridge end date updation
		DEBUG("[$loadTable]:Running SCD6 bridge table end date updation");
		$handle = $db->prepare($prepareEndDateUpdate) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	}
	
    # Create a Merge SQL that updates/inserts rows from the LOCAL TEMP Table created above into the
    # DWH dim table
    my $merge_sql = "MERGE INTO OO_EXECUTION_SUMMARY USING LOCAL_TEMP_OO_EXECUTION_SUMMARY ON 
LOCAL_TEMP_OO_EXECUTION_SUMMARY.dsi_key_id=OO_EXECUTION_SUMMARY.dsi_key_id
 WHEN MATCHED THEN UPDATE SET 
dsi_key_id=LOCAL_TEMP_OO_EXECUTION_SUMMARY.dsi_key_id,
modified_date = getdate(),
ID=LOCAL_TEMP_OO_EXECUTION_SUMMARY.ID,
EXECUTION_ID=LOCAL_TEMP_OO_EXECUTION_SUMMARY.EXECUTION_ID,
FLOW_UUID=LOCAL_TEMP_OO_EXECUTION_SUMMARY.FLOW_UUID,
FLOW_PATH=LOCAL_TEMP_OO_EXECUTION_SUMMARY.FLOW_PATH,
RESULT_STATUS_TYPE=LOCAL_TEMP_OO_EXECUTION_SUMMARY.RESULT_STATUS_TYPE,
RESULT_STATUS_NAME=LOCAL_TEMP_OO_EXECUTION_SUMMARY.RESULT_STATUS_NAME,
PAUSE_REASON=LOCAL_TEMP_OO_EXECUTION_SUMMARY.PAUSE_REASON,
OWNER=LOCAL_TEMP_OO_EXECUTION_SUMMARY.OWNER,
TRIGGERED_BY=LOCAL_TEMP_OO_EXECUTION_SUMMARY.TRIGGERED_BY,
EXECUTION_NAME=LOCAL_TEMP_OO_EXECUTION_SUMMARY.EXECUTION_NAME,
DURATION=LOCAL_TEMP_OO_EXECUTION_SUMMARY.DURATION,
TRIGGER_SOURCE=LOCAL_TEMP_OO_EXECUTION_SUMMARY.TRIGGER_SOURCE,
LOG_LEVEL=LOCAL_TEMP_OO_EXECUTION_SUMMARY.LOG_LEVEL,
RUNNING_CONF_VERSION=LOCAL_TEMP_OO_EXECUTION_SUMMARY.RUNNING_CONF_VERSION,
TIMEOUT=LOCAL_TEMP_OO_EXECUTION_SUMMARY.TIMEOUT,
CANCEL_REASON=LOCAL_TEMP_OO_EXECUTION_SUMMARY.CANCEL_REASON,
START_TIME_LONG=LOCAL_TEMP_OO_EXECUTION_SUMMARY.START_TIME_LONG,
END_TIME_LONG=LOCAL_TEMP_OO_EXECUTION_SUMMARY.END_TIME_LONG,
STATUS=LOCAL_TEMP_OO_EXECUTION_SUMMARY.STATUS,
isdeleted=LOCAL_TEMP_OO_EXECUTION_SUMMARY.isdeleted,
source=LOCAL_TEMP_OO_EXECUTION_SUMMARY.source,
sourceid=LOCAL_TEMP_OO_EXECUTION_SUMMARY.sourceid,
extraction_time=LOCAL_TEMP_OO_EXECUTION_SUMMARY.extraction_time 
 WHEN NOT MATCHED THEN INSERT 
(
dsi_key_id,
creation_date,
modified_date,
ID,
EXECUTION_ID,
FLOW_UUID,
FLOW_PATH,
RESULT_STATUS_TYPE,
RESULT_STATUS_NAME,
PAUSE_REASON,
OWNER,
TRIGGERED_BY,
EXECUTION_NAME,
DURATION,
TRIGGER_SOURCE,
LOG_LEVEL,
RUNNING_CONF_VERSION,
TIMEOUT,
CANCEL_REASON,
START_TIME_LONG,
END_TIME_LONG,
STATUS,
isdeleted,
source,
sourceid,
extraction_time)
 VALUES 
(
LOCAL_TEMP_OO_EXECUTION_SUMMARY.dsi_key_id,
getdate(),
getdate(),
LOCAL_TEMP_OO_EXECUTION_SUMMARY.ID,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.EXECUTION_ID,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.FLOW_UUID,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.FLOW_PATH,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.RESULT_STATUS_TYPE,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.RESULT_STATUS_NAME,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.PAUSE_REASON,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.OWNER,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.TRIGGERED_BY,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.EXECUTION_NAME,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.DURATION,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.TRIGGER_SOURCE,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.LOG_LEVEL,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.RUNNING_CONF_VERSION,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.TIMEOUT,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.CANCEL_REASON,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.START_TIME_LONG,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.END_TIME_LONG,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.STATUS,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.isdeleted,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.source,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.sourceid,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.extraction_time)";
	
	#do only insert if this module is getting called as part of reference
	if( $table ne $loadTable ){
		DEBUG("[$loadTable]:Replacing merge with insert SQL");
		$merge_sql = "INSERT INTO OO_EXECUTION_SUMMARY(
dsi_key_id,
creation_date,
modified_date,
ID,
EXECUTION_ID,
FLOW_UUID,
FLOW_PATH,
RESULT_STATUS_TYPE,
RESULT_STATUS_NAME,
PAUSE_REASON,
OWNER,
TRIGGERED_BY,
EXECUTION_NAME,
DURATION,
TRIGGER_SOURCE,
LOG_LEVEL,
RUNNING_CONF_VERSION,
TIMEOUT,
CANCEL_REASON,
START_TIME_LONG,
END_TIME_LONG,
STATUS,
isdeleted,
source,
sourceid,
extraction_time)
 SELECT 
LOCAL_TEMP_OO_EXECUTION_SUMMARY.dsi_key_id,
getdate(),
getdate(),
LOCAL_TEMP_OO_EXECUTION_SUMMARY.ID,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.EXECUTION_ID,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.FLOW_UUID,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.FLOW_PATH,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.RESULT_STATUS_TYPE,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.RESULT_STATUS_NAME,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.PAUSE_REASON,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.OWNER,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.TRIGGERED_BY,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.EXECUTION_NAME,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.DURATION,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.TRIGGER_SOURCE,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.LOG_LEVEL,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.RUNNING_CONF_VERSION,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.TIMEOUT,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.CANCEL_REASON,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.START_TIME_LONG,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.END_TIME_LONG,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.STATUS,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.isdeleted,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.source,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.sourceid,
LOCAL_TEMP_OO_EXECUTION_SUMMARY.extraction_time FROM LOCAL_TEMP_OO_EXECUTION_SUMMARY
 WHERE LOCAL_TEMP_OO_EXECUTION_SUMMARY.dsi_key_id NOT IN (SELECT dsi_key_id FROM OO_EXECUTION_SUMMARY)";	
	}
	
    # merge local temp table with dim table
    DEBUG("[$loadTable]:Running MERGE SQL for $table");
    $handle = $db->prepare($merge_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
    $handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
    # bridge table SDC6 update SQL
    my $SCD6BridgeUpdate = '';
	if( $SCD6BridgeUpdate ne '' ){
		# scd6 bridge end date updation SQL
		DEBUG("[$loadTable]:Running SCD6 bridge table updation SQL");
		$handle = $db->prepare($SCD6BridgeUpdate) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	}
	
    # drop external table
    my $drop_ext_table = "DROP TABLE IF EXISTS EXTERNAL_OO_EXECUTION_SUMMARY";
    DEBUG("[$loadTable]:Dropping external temporary table");
    $handle = $db->prepare($drop_ext_table) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
    $handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
    my $drop_temp_table = "DROP TABLE IF EXISTS LOCAL_TEMP_OO_EXECUTION_SUMMARY";
    DEBUG("[$loadTable]:Dropping temporary table");
    $handle = $db->prepare($drop_temp_table) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
    $handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	my $drop_temp_table_scd6_brdge = '';
	if( $drop_temp_table_scd6_brdge ne '' ){
		# no need to drop the local temp table - should be cleaned up on session end
		DEBUG("[$loadTable]:Dropping SCD6 bridge temporary table");
		$handle = $db->prepare($drop_temp_table_scd6_brdge) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);		
	}

	if( $isDirectLoad == 1){
		# delete the consolidated CSV file
		unlink($out_file);
	}
	
	#Commit transaction before exiting
	my $commitTrans = "COMMIT";
	DEBUG("[$loadTable]:Issuing commit");
	$handle = $db->prepare($commitTrans) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	DEBUG("[$loadTable]:Returning to main program");
}
1;
