# Copyright 2014, Hewlett-Packard Company
#
# Sub routine to load table OO_EXECUTION_BOUND_INPUTS_DT
#
# Arguments:
#
# CSV File Name
# Reference to a map between DB column names and CSV column names
# Reference to DB Connection
#



sub OO_EXECUTION_BOUND_INPUTS_DT {

	# the name of the caller table (base table of the load)
    my $loadTable = shift;

    DEBUG("[$loadTable]:Calling OO_EXECUTION_BOUND_INPUTS_DT subroutine");
    
	# mapping from DB columns names to CSV
    my $db_csv_map_ref = shift;
	
	# DB connection
    my $db = shift;

	#base temporary table which has data from stage table
	my $baseTempTableName = shift;

	#table name
	my $tableName = shift;

	#Master table of
	my $masterTableOf = shift;
	
	#used for bridge table
	my $associationColMap = shift;
	
	# DB Column Names in the format tablename_columnname
	my @dbColumns = ("OO_EXECUTION_BOUND_INPUTS_0_ID","OO_EXECUTION_BOUND_INPUTS_DT_0_ta_period","OO_EXECUTION_BOUND_INPUTS_DT_0_dt_from","OO_EXECUTION_BOUND_INPUTS_DT_0_dt_to","OO_EXECUTION_BOUND_INPUTS_DT_0_dt_type","OO_EXECUTION_BOUND_INPUTS_DT_0_source","OO_EXECUTION_BOUND_INPUTS_DT_0_sourceid","OO_EXECUTION_BOUND_INPUTS_DT_0_extraction_time");
	
	my %map = %$db_csv_map_ref;    
	
    # list of business keys for this dim
    my @biz_cols = ("ta_period","ID");
    # DB column names
    my @db_hdr = ("ta_period","dt_from","dt_to","dt_type","source","sourceid","extraction_time","ID");

    # this table name
    my $table = 'OO_EXECUTION_BOUND_INPUTS_DT';
	
	my $temp_table = "LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT";
	my $dim_seq = "OO_EXECUTION_BOUND_INPUTS_DT_sequence";
	my $extTempTable = "EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT";
	my $create_temp_table_sql;

	#prepare the select column list from the column map from main and columns in this pm		
	my @colFrmMapTemp = keys %map; #first get keys from col reference map
	my $strTemp = join(",",@colFrmMapTemp);
	$strTemp =~ s/\./_0_/g; #now remove the "." with "_0_"
	#$strTemp =~ s/,/,\n/g; # replace comma with comma and new line
	my @colFrmMap = split(",",$strTemp);
	
	my %dbColumns=map{$_ =>1} @dbColumns;
	my %colFrmMap1=map{$_=>1} @colFrmMap;
	my @reqColumnsArr = grep( $colFrmMap1{$_}, @dbColumns ); #now get the intersection of two arrays
	
	my $reqSelCols = join(",",@reqColumnsArr);
	$reqSelCols =~ s/,/,\n/g;
	
	#get the columns required for group by. This will be the list of business key columns of this table and associated tables
	
	my @tmpBkColsArr = ("OO_EXECUTION_BOUND_INPUTS_DT_0_ta_period","OO_EXECUTION_BOUND_INPUTS_0_ID");	
	
	my %tmpBkColsArr=map{$_ =>1} @tmpBkColsArr;
	my %colFrmMap2=map{$_=>1} @colFrmMap;
	my @reqGrpColumnsArr = grep( $colFrmMap2{$_}, @tmpBkColsArr ); #now get the intersection of two arrays
	
	my $reqGrpByCols = join(",",@reqGrpColumnsArr);
	$reqGrpByCols =~ s/,/,\n/g;
	
	# Create intermediate local ext temp table
	
	my $create_ddl = "CREATE LOCAL TEMPORARY TABLE  EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT (
OO_EXECUTION_BOUND_INPUTS_DT_0_ta_period timestamp,
OO_EXECUTION_BOUND_INPUTS_DT_0_dt_from timestamp,
OO_EXECUTION_BOUND_INPUTS_DT_0_dt_to timestamp,
OO_EXECUTION_BOUND_INPUTS_DT_0_dt_type VARCHAR (255),
OO_EXECUTION_BOUND_INPUTS_DT_0_source VARCHAR (255),
OO_EXECUTION_BOUND_INPUTS_DT_0_sourceid VARCHAR (255),
OO_EXECUTION_BOUND_INPUTS_DT_0_extraction_time timestamp,
OO_EXECUTION_BOUND_INPUTS_0_ID float) ON COMMIT PRESERVE ROWS ORDER BY OO_EXECUTION_BOUND_INPUTS_0_ID ";
	DEBUG("[$loadTable]:Create ext temp table");
	my $handle = $db->prepare($create_ddl) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	# Create intermediate local temp table
	my $createLocalTempDDLSQL = "CREATE LOCAL TEMPORARY TABLE  LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT (
dsi_key_id integer,
ta_period timestamp,
dt_from timestamp,
dt_to timestamp,
dt_type VARCHAR (255),
source VARCHAR (255),
sourceid VARCHAR (255),
extraction_time timestamp) ON COMMIT PRESERVE ROWS ORDER BY dsi_key_id, ta_period ";	
	DEBUG("[$loadTable]:Create local temp table");
	my $handle = $db->prepare($createLocalTempDDLSQL) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode); 

	# select into intermediate local temp table
	my $reqBaseSelCols = $reqSelCols;
	if( $masterTableOf ne '' ){
		my $tmpTableName = $tableName . "_0_";
		my $tmpMasterTableOf = $masterTableOf . "_0_";
		$reqBaseSelCols =~ s/$tmpTableName/$tmpMasterTableOf/g; #incase of conformedTo table conformed table name should be used
		$reqGrpByCols =~ s/$tmpTableName/$tmpMasterTableOf/g; #incase of conformedTo table conformed table name should be used
	}
	
	# move data from ext temp table to base temp table. Duplicate deletion happens here
	my $checkDuplicate = 1;	
	if( $checkDuplicate == 1 ){
		$create_temp_table_sql = "INSERT INTO $extTempTable ( $reqSelCols ) SELECT $reqBaseSelCols FROM $baseTempTableName WHERE IDENCOL IN( SELECT MAX(IDENCOL) FROM $baseTempTableName GROUP BY $reqGrpByCols ) ";
	}
	else{
		$create_temp_table_sql = "INSERT INTO $extTempTable ( $reqSelCols ) SELECT $reqBaseSelCols FROM $baseTempTableName ";		
	}
	DEBUG("[$loadTable]:Creating/selecting to external table SQL: $create_temp_table_sql");
	$handle = $db->prepare($create_temp_table_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);	

	#lock the table to avoid parallel loads
	#my $lockTable = "LOCK TABLE OO_EXECUTION_BOUND_INPUTS_DT";
	#DEBUG("[$loadTable]:Locking table $table");
	#$handle = $db->prepare($lockTable) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	#$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);	
	
	#get default business key values from dimension tables
	my $OO_EXECUTION_BOUND_INPUTS_0_ID;
	my $OO_EXECUTION_BOUND_INPUTSStmt = $db->prepare("SELECT ID FROM OO_EXECUTION_BOUND_INPUTS WHERE dsi_key_id = 1 ") or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	my $OO_EXECUTION_BOUND_INPUTSRs = $OO_EXECUTION_BOUND_INPUTSStmt->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	if( $OO_EXECUTION_BOUND_INPUTSRs >= 0){
		if( my @OO_EXECUTION_BOUND_INPUTSRow = $OO_EXECUTION_BOUND_INPUTSStmt->fetchrow_array() ){
			$OO_EXECUTION_BOUND_INPUTS_0_ID = $OO_EXECUTION_BOUND_INPUTSRow[0];
			}
	}
		
	
	# Create a LOCAL TEMP table and populate it with contents of the base temp table outer joined with the contents of the DWH Dim table
	my $select_into_temp_sql = "INSERT INTO LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT
(dsi_key_id,ta_period,dt_from,dt_to,dt_type,source,sourceid,extraction_time) 
SELECT 
NVL(OO_EXECUTION_BOUND_INPUTS.dsi_key_id,1) AS dsi_key_id,
EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT.OO_EXECUTION_BOUND_INPUTS_DT_0_ta_period AS ta_period,
EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT.OO_EXECUTION_BOUND_INPUTS_DT_0_dt_from AS dt_from,
EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT.OO_EXECUTION_BOUND_INPUTS_DT_0_dt_to AS dt_to,
EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT.OO_EXECUTION_BOUND_INPUTS_DT_0_dt_type AS dt_type,
EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT.OO_EXECUTION_BOUND_INPUTS_DT_0_source AS source,
EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT.OO_EXECUTION_BOUND_INPUTS_DT_0_sourceid AS sourceid,
EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT.OO_EXECUTION_BOUND_INPUTS_DT_0_extraction_time AS extraction_time
FROM EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT 
LEFT OUTER JOIN (SELECT OO_EXECUTION_BOUND_INPUTS.dsi_key_id , OO_EXECUTION_BOUND_INPUTS.ID FROM  OO_EXECUTION_BOUND_INPUTS OO_EXECUTION_BOUND_INPUTS  ) OO_EXECUTION_BOUND_INPUTS ON ( OO_EXECUTION_BOUND_INPUTS.ID = NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT.OO_EXECUTION_BOUND_INPUTS_0_ID, $OO_EXECUTION_BOUND_INPUTS_0_ID ) )";
	DEBUG("[$loadTable]:Creating LOCAL TEMP Table $temp_table");
	$handle = $db->prepare($select_into_temp_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
    # Create an UPDATE SQL that updates rows from the LOCAL TEMP Table created above into the
    # DWH fact table
    my $update_sql = "";
	if( $update_sql ne "" ){
		# update local temp table to fact table
		DEBUG("[$loadTable]:Running UPDATE SQL for $table");
		$handle = $db->prepare($update_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);	
	}
	
    # Create an INSERT SQL that inserts rows from the LOCAL TEMP Table created above into the
    # insert local temp table into fact table
    my $insert_sql = "INSERT INTO OO_EXECUTION_BOUND_INPUTS_DT(
dsi_key_id_,
creation_date,
modified_date,
ta_period,
dt_from,
dt_to,
dt_type,
source,
sourceid,
extraction_time)
( SELECT 
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.dsi_key_id,
getdate(),
getdate(),
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.ta_period,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.dt_from,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.dt_to,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.dt_type,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.source,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.sourceid,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.extraction_time
 FROM LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT
 LEFT JOIN OO_EXECUTION_BOUND_INPUTS_DT SRTMP ON  SRTMP.TA_PERIOD = LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.TA_PERIOD AND  NVL(SRTMP.dsi_key_id_,0) = NVL(LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT.dsi_key_id,0) WHERE SRTMP.TA_PERIOD  IS NULL )";	
    DEBUG("[$loadTable]:Running INSERT SQL for $table");
    $handle = $db->prepare($insert_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
    $handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	    
    # drop external table
	my $drop_ext_table = "DROP TABLE IF EXISTS EXTERNAL_OO_EXECUTION_BOUND_INPUTS_DT";
    DEBUG("[$loadTable]:Dropping external temporary table");
    $handle = $db->prepare($drop_ext_table) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
    $handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);

    # drop local temp table
	my $drop_temp_table = "DROP TABLE IF EXISTS LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS_DT";
    DEBUG("[$loadTable]:Dropping temporary table");
    $handle = $db->prepare($drop_temp_table) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
    $handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);

	if( $isDirectLoad == 1){
		# delete the consolidated CSV file
		unlink($out_file);
	}

	#Commit transaction before exiting
	my $commitTrans = "COMMIT";
	DEBUG("[$loadTable]:Issuing commit");
	$handle = $db->prepare($commitTrans) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	DEBUG("[$loadTable]:Returning to main program");	
}
1;
