# Copyright 2014, Hewlett-Packard Company
#
# Sub routine to load table OO_EXECUTION_BOUND_INPUTS
#
# Arguments:
#
# CSV File Name
# Reference to a map between DB column names and CSV column names
# Reference to DB Connection
#



sub OO_EXECUTION_BOUND_INPUTS {
	# the name of the caller table (base table of the load)
    my $loadTable = shift;

    DEBUG("[$loadTable]:Calling OO_EXECUTION_BOUND_INPUTS subroutine");
    
	# mapping from DB columns names to CSV
    my $db_csv_map_ref = shift;
	
	# DB connection
    my $db = shift;

	#base temporary table which has data from stage table
	my $baseTempTableName = shift;

	#table name
	my $tableName = shift;

	#Master table of
	my $masterTableOf = shift;
	
	#used for bridge table
	my $associationColMap = shift;
	
	# DB Column Names in the format tablename_columnname
	my @dbColumns = ("OO_EXECUTION_BOUND_INPUTS_0_ID","OO_EXECUTION_BOUND_INPUTS_0_INPUT_NAME","OO_EXECUTION_BOUND_INPUTS_0_VALUE","OO_EXECUTION_BOUND_INPUTS_0_BIG_VALUE","OO_EXECUTION_BOUND_INPUTS_0_EXECUTION_ID","OO_EXECUTION_BOUND_INPUTS_0_isdeleted","OO_EXECUTION_BOUND_INPUTS_0_source","OO_EXECUTION_BOUND_INPUTS_0_sourceid","OO_EXECUTION_BOUND_INPUTS_0_extraction_time");
	
	my %map = %$db_csv_map_ref;    
	
    # list of business keys for this dim
    my @biz_cols = ("ID");
    # DB column names
    my @db_hdr = ("ID","INPUT_NAME","VALUE","BIG_VALUE","EXECUTION_ID","isdeleted","source","sourceid","extraction_time");

    # this table name
    my $table = 'OO_EXECUTION_BOUND_INPUTS';
	
	my $temp_table = "LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS";
	my $dim_seq = "OO_EXECUTION_BOUND_INPUTS_sequence";
	my $extTempTable = "EXTERNAL_OO_EXECUTION_BOUND_INPUTS";
	my $create_temp_table_sql;

	#prepare the select column list from the column map from main and columns in this pm		
	my @colFrmMapTemp = keys %map; #first get keys from col reference map
	my $strTemp = join(",",@colFrmMapTemp);
	$strTemp =~ s/\./_0_/g; #now remove the "." with "_0_"
	#$strTemp =~ s/,/,\n/g; # replace comma with comma and new line
	my @colFrmMap = split(",",$strTemp);
	
	my %dbColumns=map{$_ =>1} @dbColumns;
	my %colFrmMap1=map{$_=>1} @colFrmMap;
	my @reqColumnsArr = grep( $colFrmMap1{$_}, @dbColumns ); #now get the intersection of two arrays
	
	my $reqSelCols = join(",",@reqColumnsArr);
	$reqSelCols =~ s/,/,\n/g;
	
	#get the columns required for group by. This will be the list of business key columns of this table and associated tables
	
	my @tmpBkColsArr = ("OO_EXECUTION_BOUND_INPUTS_0_ID");	
	
	my %tmpBkColsArr=map{$_ =>1} @tmpBkColsArr;
	my %colFrmMap2=map{$_=>1} @colFrmMap;
	my @reqGrpColumnsArr = grep( $colFrmMap2{$_}, @tmpBkColsArr ); #now get the intersection of two arrays
	
	my $reqGrpByCols = join(",",@reqGrpColumnsArr);
	$reqGrpByCols =~ s/,/,\n/g;
	
	# Create intermediate local ext temp table
	
	my $create_ddl = "CREATE LOCAL TEMPORARY TABLE  EXTERNAL_OO_EXECUTION_BOUND_INPUTS (
OO_EXECUTION_BOUND_INPUTS_0_ID float,
OO_EXECUTION_BOUND_INPUTS_0_INPUT_NAME VARCHAR (255),
OO_EXECUTION_BOUND_INPUTS_0_VALUE VARCHAR (4000),
OO_EXECUTION_BOUND_INPUTS_0_BIG_VALUE VARCHAR (5000),
OO_EXECUTION_BOUND_INPUTS_0_EXECUTION_ID VARCHAR (255),
OO_EXECUTION_BOUND_INPUTS_0_isdeleted integer,
OO_EXECUTION_BOUND_INPUTS_0_source VARCHAR (255),
OO_EXECUTION_BOUND_INPUTS_0_sourceid VARCHAR (255),
OO_EXECUTION_BOUND_INPUTS_0_extraction_time timestamp) ON COMMIT PRESERVE ROWS ORDER BY OO_EXECUTION_BOUND_INPUTS_0_ID ";
	DEBUG("[$loadTable]:Create ext temp table");
	my $handle = $db->prepare($create_ddl) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	# Create intermediate local temp table
	my $createLocalTempDDLSQL = "CREATE LOCAL TEMPORARY TABLE  LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS (
dsi_key_id integer,
ID float,
INPUT_NAME VARCHAR (255),
VALUE VARCHAR (4000),
BIG_VALUE VARCHAR (5000),
EXECUTION_ID VARCHAR (255),
isdeleted integer,
source VARCHAR (255),
sourceid VARCHAR (255),
extraction_time timestamp) ON COMMIT PRESERVE ROWS ORDER BY dsi_key_id ";
	DEBUG("[$loadTable]:Create local temp table");
	my $handle = $db->prepare($createLocalTempDDLSQL) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);

	# select into intermediate local temp table
	my $reqBaseSelCols = $reqSelCols;
	if( $masterTableOf ne '' ){
		my $tmpTableName = $tableName . "_0_";
		my $tmpMasterTableOf = $masterTableOf . "_0_";
		$reqBaseSelCols =~ s/$tmpTableName/$tmpMasterTableOf/g; #incase of conformedTo table conformed table name should be used
		$reqGrpByCols =~ s/$tmpTableName/$tmpMasterTableOf/g; #incase of conformedTo table conformed table name should be used
	}
	
	#for bridge table support
	if( $associationColMap ne '' ){
		my %asscnColArr = split /[,]/, $associationColMap;
		
		foreach my $dstCol (keys %asscnColArr) {				
			my $tgtColName = $masterTableOf . "_0_" . $dstCol;
			my $srcColName = $masterTableOf . "_0_" . $asscnColArr{$dstCol};
			
			$reqBaseSelCols =~ s/$srcColName/$tgtColName/g; #incase of bridge table replace association column name with actual dependent table column name
			$reqGrpByCols =~ s/$srcColName/$tgtColName/g; #incase of bridge table replace association column name with actual dependent table column name
		}			
	}
	
	# move data from ext temp table to base temp table. Duplicate deletion happens here
	my $checkDuplicate = 1;	
	if( $checkDuplicate == 1 ){
		$create_temp_table_sql = "INSERT INTO $extTempTable ( $reqSelCols ) SELECT $reqBaseSelCols FROM $baseTempTableName WHERE IDENCOL IN( SELECT MAX(IDENCOL) FROM $baseTempTableName GROUP BY $reqGrpByCols ) ";
	}
	else{
		$create_temp_table_sql = "INSERT INTO $extTempTable ( $reqSelCols ) SELECT $reqBaseSelCols FROM $baseTempTableName ";		
	}
	DEBUG("[$loadTable]:Creating/selecting to external table SQL: $create_temp_table_sql");
	$handle = $db->prepare($create_temp_table_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);

	#lock the table to avoid parallel loads
	my $lockTable = "LOCK TABLE OO_EXECUTION_BOUND_INPUTS";
	DEBUG("[$loadTable]:Locking table $tableName");
	$handle = $db->prepare($lockTable) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	#get default business key values from dimension tables
	my $OO_EXECUTION_BOUND_INPUTS_0_ID;
	my $OO_EXECUTION_BOUND_INPUTSStmt = $db->prepare("SELECT ID FROM OO_EXECUTION_BOUND_INPUTS WHERE dsi_key_id = 1 ") or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	my $OO_EXECUTION_BOUND_INPUTSRs = $OO_EXECUTION_BOUND_INPUTSStmt->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	if( $OO_EXECUTION_BOUND_INPUTSRs >= 0){
		if( my @OO_EXECUTION_BOUND_INPUTSRow = $OO_EXECUTION_BOUND_INPUTSStmt->fetchrow_array() ){
			$OO_EXECUTION_BOUND_INPUTS_0_ID = $OO_EXECUTION_BOUND_INPUTSRow[0];
			}
	}
	
	
	# Create a LOCAL TEMP table and populate it with contents of the base temp table outer joined with the contents of the DWH Dim table
	my $select_into_temp_sql = "INSERT INTO LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS
(dsi_key_id,ID,INPUT_NAME,VALUE,BIG_VALUE,EXECUTION_ID,isdeleted,source,sourceid,extraction_time) 
SELECT 
(CASE WHEN OO_EXECUTION_BOUND_INPUTS.dsi_key_id IS NULL THEN OO_EXECUTION_BOUND_INPUTS_sequence.NEXTVAL ELSE OO_EXECUTION_BOUND_INPUTS.dsi_key_id END) AS dsi_key_id,
NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_ID,OO_EXECUTION_BOUND_INPUTS.ID) AS ID,
NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_INPUT_NAME,OO_EXECUTION_BOUND_INPUTS.INPUT_NAME) AS INPUT_NAME,
NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_VALUE,OO_EXECUTION_BOUND_INPUTS.VALUE) AS VALUE,
NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_BIG_VALUE,OO_EXECUTION_BOUND_INPUTS.BIG_VALUE) AS BIG_VALUE,
NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_EXECUTION_ID,OO_EXECUTION_BOUND_INPUTS.EXECUTION_ID) AS EXECUTION_ID,
NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_isdeleted,OO_EXECUTION_BOUND_INPUTS.isdeleted) AS isdeleted,
NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_source,OO_EXECUTION_BOUND_INPUTS.source) AS source,
NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_sourceid,OO_EXECUTION_BOUND_INPUTS.sourceid) AS sourceid,
NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_extraction_time,OO_EXECUTION_BOUND_INPUTS.extraction_time) AS extraction_time
FROM EXTERNAL_OO_EXECUTION_BOUND_INPUTS 
LEFT OUTER JOIN (SELECT OO_EXECUTION_BOUND_INPUTS.dsi_key_id , OO_EXECUTION_BOUND_INPUTS.ID , OO_EXECUTION_BOUND_INPUTS.INPUT_NAME , OO_EXECUTION_BOUND_INPUTS.VALUE , OO_EXECUTION_BOUND_INPUTS.BIG_VALUE , OO_EXECUTION_BOUND_INPUTS.EXECUTION_ID , OO_EXECUTION_BOUND_INPUTS.isdeleted , OO_EXECUTION_BOUND_INPUTS.source , OO_EXECUTION_BOUND_INPUTS.sourceid , OO_EXECUTION_BOUND_INPUTS.extraction_time FROM  OO_EXECUTION_BOUND_INPUTS OO_EXECUTION_BOUND_INPUTS  ) OO_EXECUTION_BOUND_INPUTS ON ( OO_EXECUTION_BOUND_INPUTS.ID = NVL(EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_ID, $OO_EXECUTION_BOUND_INPUTS_0_ID ) )
 WHERE EXTERNAL_OO_EXECUTION_BOUND_INPUTS.OO_EXECUTION_BOUND_INPUTS_0_ID is not null ";
	DEBUG("[$loadTable]:Creating LOCAL TEMP Table $temp_table");
	$handle = $db->prepare($select_into_temp_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);	
	
	# Create another LOCAL TEMP table in case of SCD6 bridge table
	my $prepare_temp_table = '';	
	if( $prepare_temp_table ne '' ){
		# scd6 bridge record consolidation
		DEBUG("[$loadTable]:Running SCD6 bridge table record consolidation SQL");
		$handle = $db->prepare($prepare_temp_table) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	}
	
	# SQL to delete duplicate records from SCD6 bridge table
	my $scd6_bridge_duplicate_removal = '';	
	if( $scd6_bridge_duplicate_removal ne '' ){
		# scd6 bridge duplicate deletion
		DEBUG("[$loadTable]:Running SCD6 bridge duplicate or incomplete record deletion");
		$handle = $db->prepare($scd6_bridge_duplicate_removal) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	}
	
	# update the LOCAL TEMP table with end_date for those records which are complete
	my $prepareEndDateUpdate = '';	
	if( $prepareEndDateUpdate ne '' ){
		# scd6 bridge end date updation
		DEBUG("[$loadTable]:Running SCD6 bridge table end date updation");
		$handle = $db->prepare($prepareEndDateUpdate) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	}
	
    # Create a Merge SQL that updates/inserts rows from the LOCAL TEMP Table created above into the
    # DWH dim table
    my $merge_sql = "MERGE INTO OO_EXECUTION_BOUND_INPUTS USING LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS ON 
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.dsi_key_id=OO_EXECUTION_BOUND_INPUTS.dsi_key_id
 WHEN MATCHED THEN UPDATE SET 
dsi_key_id=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.dsi_key_id,
modified_date = getdate(),
ID=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.ID,
INPUT_NAME=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.INPUT_NAME,
VALUE=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.VALUE,
BIG_VALUE=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.BIG_VALUE,
EXECUTION_ID=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.EXECUTION_ID,
isdeleted=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.isdeleted,
source=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.source,
sourceid=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.sourceid,
extraction_time=LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.extraction_time 
 WHEN NOT MATCHED THEN INSERT 
(
dsi_key_id,
creation_date,
modified_date,
ID,
INPUT_NAME,
VALUE,
BIG_VALUE,
EXECUTION_ID,
isdeleted,
source,
sourceid,
extraction_time)
 VALUES 
(
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.dsi_key_id,
getdate(),
getdate(),
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.ID,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.INPUT_NAME,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.VALUE,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.BIG_VALUE,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.EXECUTION_ID,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.isdeleted,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.source,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.sourceid,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.extraction_time)";
	
	#do only insert if this module is getting called as part of reference
	if( $table ne $loadTable ){
		DEBUG("[$loadTable]:Replacing merge with insert SQL");
		$merge_sql = "INSERT INTO OO_EXECUTION_BOUND_INPUTS(
dsi_key_id,
creation_date,
modified_date,
ID,
INPUT_NAME,
VALUE,
BIG_VALUE,
EXECUTION_ID,
isdeleted,
source,
sourceid,
extraction_time)
 SELECT 
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.dsi_key_id,
getdate(),
getdate(),
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.ID,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.INPUT_NAME,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.VALUE,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.BIG_VALUE,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.EXECUTION_ID,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.isdeleted,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.source,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.sourceid,
LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.extraction_time FROM LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS
 WHERE LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS.dsi_key_id NOT IN (SELECT dsi_key_id FROM OO_EXECUTION_BOUND_INPUTS)";	
	}
	
    # merge local temp table with dim table
    DEBUG("[$loadTable]:Running MERGE SQL for $table");
    $handle = $db->prepare($merge_sql) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
    $handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
    # bridge table SDC6 update SQL
    my $SCD6BridgeUpdate = '';
	if( $SCD6BridgeUpdate ne '' ){
		# scd6 bridge end date updation SQL
		DEBUG("[$loadTable]:Running SCD6 bridge table updation SQL");
		$handle = $db->prepare($SCD6BridgeUpdate) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	}
	
    # drop external table
    my $drop_ext_table = "DROP TABLE IF EXISTS EXTERNAL_OO_EXECUTION_BOUND_INPUTS";
    DEBUG("[$loadTable]:Dropping external temporary table");
    $handle = $db->prepare($drop_ext_table) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
    $handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
    my $drop_temp_table = "DROP TABLE IF EXISTS LOCAL_TEMP_OO_EXECUTION_BOUND_INPUTS";
    DEBUG("[$loadTable]:Dropping temporary table");
    $handle = $db->prepare($drop_temp_table) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
    $handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	my $drop_temp_table_scd6_brdge = '';
	if( $drop_temp_table_scd6_brdge ne '' ){
		# no need to drop the local temp table - should be cleaned up on session end
		DEBUG("[$loadTable]:Dropping SCD6 bridge temporary table");
		$handle = $db->prepare($drop_temp_table_scd6_brdge) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
		$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);		
	}

	if( $isDirectLoad == 1){
		# delete the consolidated CSV file
		unlink($out_file);
	}
	
	#Commit transaction before exiting
	my $commitTrans = "COMMIT";
	DEBUG("[$loadTable]:Issuing commit");
	$handle = $db->prepare($commitTrans) or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	$handle->execute() or handle_error("[$loadTable]:".$DBI::errstr, $errCode);
	
	DEBUG("[$loadTable]:Returning to main program");
}
1;
